/**
 * Generates a placeholder image URL for missing product/service images
 */
export function getImagePlaceholder(
  text: string,
  width: number = 400,
  height: number = 400,
  bgColor: string = 'f3f4f6',
  textColor: string = '9ca3af'
): string {
  const encodedText = encodeURIComponent(text)
  return `https://via.placeholder.com/${width}x${height}/${bgColor}/${textColor}?text=${encodedText}`
}

/**
 * Handles image error by replacing src with placeholder
 */
export function handleImageError(
  event: React.SyntheticEvent<HTMLImageElement>,
  placeholderText: string
) {
  const target = event.target as HTMLImageElement
  target.src = getImagePlaceholder(placeholderText)
}
